/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.init;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.HugeFungusConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ReplaceSphereConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SpringConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.material.Fluids;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.init.IEFeatures;
import org.infernalstudios.infernalexp.world.gen.features.config.GlowSpikeFeatureConfig;
import org.infernalstudios.infernalexp.world.gen.features.config.PlantedQuartzFeatureConfig;

public class IEConfiguredFeatures {
    public static final RuleTest BASALT = new BlockMatchTest(Blocks.f_50137_);
    public static final RuleTest SOUL_SOIL = new BlockMatchTest(Blocks.f_50136_);
    public static Holder<ConfiguredFeature<?, ?>> GLOWDUST_LAYER = IEConfiguredFeatures.registerConfiguredFeature("glowdust_layer", IEFeatures.GLOWDUST_LAYER);
    public static Holder<ConfiguredFeature<?, ?>> GLOWSPIKE = IEConfiguredFeatures.registerConfiguredFeature("glowspike", IEFeatures.GLOWSPIKE, new GlowSpikeFeatureConfig(3, 5, 8, 24, 7, 7, 0.3f, true));
    public static Holder<ConfiguredFeature<?, ?>> GLOWSPIKE_LARGE = IEConfiguredFeatures.registerConfiguredFeature("glowspike_large", IEFeatures.GLOWSPIKE, new GlowSpikeFeatureConfig(4, 7, 12, 98, 12, 12, 0.2f, false));
    public static Holder<ConfiguredFeature<?, ?>> DULLTHORN_TREE_PLANTED = IEConfiguredFeatures.registerConfiguredFeature("dullthorn_tree_planted", Feature.f_65743_, new HugeFungusConfiguration(((Block)IEBlocks.GLOWDUST_SAND.get()).m_49966_(), ((Block)IEBlocks.DULLTHORNS_BLOCK.get()).m_49966_(), ((Block)IEBlocks.LUMINOUS_WART_BLOCK.get()).m_49966_(), ((Block)IEBlocks.LUMINOUS_WART_BLOCK.get()).m_49966_(), true));
    public static Holder<ConfiguredFeature<?, ?>> HANGING_GIANT_BROWN_MUSHROOM = IEConfiguredFeatures.registerConfiguredFeature("hanging_giant_brown_mushroom", IEFeatures.HANGING_GIANT_BROWN_MUSHROOM);
    public static Holder<ConfiguredFeature<?, ?>> DULLSTONE_DEATH_PIT = IEConfiguredFeatures.registerConfiguredFeature("dullstone_death_pit", IEFeatures.DULLSTONE_DEATH_PIT);
    public static Holder<ConfiguredFeature<?, ?>> LUMINOUS_FUNGUS = IEConfiguredFeatures.registerConfiguredFeature("luminous_fungus", IEFeatures.LUMINOUS_FUNGUS);
    public static Holder<ConfiguredFeature<?, ?>> DULLTHORNS = IEConfiguredFeatures.registerConfiguredFeature("dullthorns", IEFeatures.DULLTHORNS);
    public static Holder<ConfiguredFeature<?, ?>> GSC_SPRING_OPEN = IEConfiguredFeatures.registerConfiguredFeature("gsc_spring_open", Feature.f_65765_, new SpringConfiguration(Fluids.f_76195_.m_76145_(), false, 4, 1, (HolderSet)HolderSet.m_205806_(Block::m_204297_, (Object[])new Block[]{Blocks.f_50134_, (Block)IEBlocks.DULLSTONE.get(), (Block)IEBlocks.DIMSTONE.get()})));
    public static Holder<ConfiguredFeature<?, ?>> GSC_SPRING_CLOSED = IEConfiguredFeatures.registerConfiguredFeature("gsc_spring_closed", Feature.f_65765_, new SpringConfiguration(Fluids.f_76195_.m_76145_(), false, 5, 0, (HolderSet)HolderSet.m_205806_(Block::m_204297_, (Object[])new Block[]{Blocks.f_50134_, (Block)IEBlocks.DULLSTONE.get(), (Block)IEBlocks.DIMSTONE.get()})));
    public static Holder<ConfiguredFeature<?, ?>> BLACKSTONE_BOULDER = IEConfiguredFeatures.registerConfiguredFeature("blackstone_boulder", IEFeatures.BOULDER, new BlockStateConfiguration(Blocks.f_50730_.m_49966_()));
    public static Holder<ConfiguredFeature<?, ?>> GSC_BLACKSTONE_BLOBS = IEConfiguredFeatures.registerConfiguredFeature("gsc_blackstone_blob", Feature.f_65749_, new ReplaceSphereConfiguration(((Block)IEBlocks.DULLSTONE.get()).m_49966_(), Blocks.f_50730_.m_49966_(), (IntProvider)UniformInt.m_146622_((int)2, (int)3)));
    public static Holder<ConfiguredFeature<?, ?>> ORE_GLOWSILK_COCOON = IEConfiguredFeatures.registerConfiguredFeature("ore_glowsilk_cocoon", Feature.f_159727_, new OreConfiguration(OreFeatures.f_195075_, ((Block)IEBlocks.GLOWSILK_COCOON.get()).m_49966_(), 2));
    public static Holder<ConfiguredFeature<?, ?>> ORE_BASALT_IRON = IEConfiguredFeatures.registerConfiguredFeature("ore_basalt_iron", Feature.f_65731_, new OreConfiguration(BASALT, ((Block)IEBlocks.BASALT_IRON_ORE.get()).m_49966_(), 8));
    public static Holder<ConfiguredFeature<?, ?>> PATCH_GLOW_FIRE = IEConfiguredFeatures.registerConfiguredFeature("patch_glow_fire", Feature.f_65763_, FeatureUtils.m_206476_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)IEBlocks.GLOW_FIRE.get()))), List.of((Block)IEBlocks.GLOWDUST_SAND.get())));
    public static Holder<ConfiguredFeature<?, ?>> BASALTIC_MAGMA = IEConfiguredFeatures.registerConfiguredFeature("basaltic_magma", Feature.f_65731_, new OreConfiguration(BASALT, ((Block)IEBlocks.BASALTIC_MAGMA.get()).m_49966_(), 10));
    public static Holder<ConfiguredFeature<?, ?>> PATCH_WARPED_CAP = IEConfiguredFeatures.registerConfiguredFeature("patch_warped_cap", Feature.f_65763_, FeatureUtils.m_206476_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)IEBlocks.WARPED_FUNGUS_CAP.get()))), List.of(Blocks.f_50690_)));
    public static Holder<ConfiguredFeature<?, ?>> PATCH_CRIMSON_CAP = IEConfiguredFeatures.registerConfiguredFeature("patch_crimson_cap", Feature.f_65763_, FeatureUtils.m_206476_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)IEBlocks.CRIMSON_FUNGUS_CAP.get()))), List.of(Blocks.f_50699_)));
    public static Holder<ConfiguredFeature<?, ?>> SHROOMLIGHT_TEAR = IEConfiguredFeatures.registerConfiguredFeature("shroomlight_tear", IEFeatures.SHROOMLIGHT_TEAR);
    public static Holder<ConfiguredFeature<?, ?>> PATCH_BURIED_BONE = IEConfiguredFeatures.registerConfiguredFeature("patch_buried_bone", Feature.f_65763_, FeatureUtils.m_206476_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)IEBlocks.BURIED_BONE.get()))), List.of(Blocks.f_50136_)));
    public static Holder<ConfiguredFeature<?, ?>> ORE_SOUL_STONE = IEConfiguredFeatures.registerConfiguredFeature("ore_soul_stone", Feature.f_65731_, new OreConfiguration(SOUL_SOIL, ((Block)IEBlocks.SOUL_STONE.get()).m_49966_(), 40));
    public static Holder<ConfiguredFeature<?, ?>> PATCH_PLANTED_QUARTZ = IEConfiguredFeatures.registerConfiguredFeature("planted_quartz_patch", IEFeatures.PATCH_PLANTED_QUARTZ, new PlantedQuartzFeatureConfig(0.95f));

    private static Holder<ConfiguredFeature<?, ?>> registerConfiguredFeature(String name, Feature<NoneFeatureConfiguration> feature) {
        return IEConfiguredFeatures.registerConfiguredFeature(name, feature, FeatureConfiguration.f_67737_);
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder<ConfiguredFeature<?, ?>> registerConfiguredFeature(String name, F feature, FC featureConfiguration) {
        ResourceLocation resourceLocation = new ResourceLocation("infernalexp", name);
        if (BuiltinRegistries.f_123861_.m_6566_().contains(resourceLocation)) {
            throw new IllegalStateException("Configured Feature ID: \"" + resourceLocation + "\" is already in the registry!");
        }
        return BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)resourceLocation, (Object)new ConfiguredFeature(feature, featureConfiguration));
    }
}

